﻿Write-Output "Mounting Driver Location script module"
Write-Output "Version 21.10.01"
$tsenv = new-object -comobject Microsoft.SMS.TSEnvironment
$wim = "$($tsenv.value("DRIVERS01"))\Drivers.wim"
$mount = "$($tsenv.value("_SMSTSMDataPath"))\mount"
$osdisk = "$($tsenv.value("OSDisk"))\"

Write-Output "---------------------------------------------------"
Write-Output "Starting to prepare drivers for In-place Upgrade..."
Write-Output "---------------------------------------------------"

#Apply Drivers.wim
if (test-path -path $wim) {
    Write-Output "Drivers.wim found"
    #Create the Mount directory
    if (!(test-path -path $mount)) {
        Write-Output "Creating mount directory $mount"
        new-item -itemtype directory -path $mount -force
        }

    #Mount the Drivers.wim file
    Write-Output "Mounting $wim to $mount"
    Mount-WindowsImage -ImagePath $wim -Index 1 -Path $mount

    #Update the DRIVERS01 path to point to the mount directory
    Write-Output "Updating the DRIVERS01 path to point to the mount directory"
    $tsenv.value("DRIVERS01") = $mount
    }

#Apply Drivers that have not been WIMed
if (!(test-path -path $wim)) {
    Write-Output "Drivers.wim NOT found...applying uncompressed drivers"
    }

if (!(test-path -path "$mount\Offline"))
    {
    Write-Output "---------------------------------------------------------"
    Write-Output "FAILED to prepare the drivers for In-Place Upgrade..."
    Write-Output "Can't find Offline Drivers Folders where expected: $Mount\Offline"
    Write-Output "Failing with Exit Code 200"
    Write-Output "---------------------------------------------------------"
    exit 200
    }

Write-Output "---------------------------------------------------------"
Write-Output "Finished to preparing the drivers for In-Place Upgrade..."
Write-Output "---------------------------------------------------------"